
#import "DHDMXConstants.h"


// Lengths
enum
{
	DHD_ARTNET_HEADER_LENGTH = 10,
	DHD_ARTNET_ARTDMX_HEADER_LENGTH = 8,
	DHD_ARTNET_ID_LENGTH = 8, // sizeof("Art-Net") (with null terminator)
};

// OpCodes
typedef enum
{
	DHDArtOpPoll       = 0x2000, // ArtPoll
	DHDArtOpPollReply  = 0x2100, // ArtPollReply
	DHDArtOpDiagData   = 0x2300,
	DHDArtOpOutput     = 0x5000, // ArtDMX
	DHDArtOpAddress    = 0x6000,
	DHDArtOpInput      = 0x7000,
	
	DHDArtOpTodRequest = 0x8000, // ArtTodRequest - RDM table of devices
	DHDArtOpTodData    = 0x8100, // 
}
DHDArtNetOpCode;



// ArtDMX
// Note mixed byte orders!!!
typedef struct
{
	uint16_t protocolVersion; // big-endian
	uint8_t  sequence; // 0 ignore, 0x1-0xff inrementing
	uint8_t  physical; // physical input port. Information only (not for routing)
	uint16_t portAddress; // little-endian, up to 15 bits
	uint16_t length; // big-endian
	uint8_t  data[DHDMX_UNIVERSE_LENGTH];
}
DHDArtNetPacketArtDMX;



// Union of all packets'
// Note byte orders
typedef struct
{
	char id[DHD_ARTNET_ID_LENGTH];
	uint16_t opCode; // little endian!
	union
	{
		DHDArtNetPacketArtDMX DMX;
	}
	data;
}
DHDArtNetPacketUnion;

